package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author TT
 */
@Api(tags = "学校管理")
@RestController
@RequestMapping("/smile/show")
public class SmileShowController {

    @Autowired
    ISmileShowService smileShowService;

    @PostMapping("/list")
    @ApiOperation("演出列表")
    @ResponseBody
    public TableDataInfo schoolList(SmileShowParam smileShowParam) {
        PageInfo<ShowVo> list = smileShowService.listShow(smileShowParam);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(list.getList());
        rspData.setTotal(list.getTotal());
        return rspData;
    }

    @GetMapping("/getShowById")
    @ApiOperation("根据演出id查询演出详情")
    public AjaxResult getShowById(String performancesId) {
        return smileShowService.getShowById(performancesId);
    }

    @PostMapping("/sort")
    @ApiOperation("演出排序")
    public AjaxResult sort(ShowSort showSort) {
        return smileShowService.sort(showSort);
    }

    @PostMapping("/price")
    @ApiOperation("打款")
    public AjaxResult price(String performancesId) {
        return smileShowService.price(performancesId);
    }

    @PostMapping("/saleData")
    @ApiOperation("销售数据")
    public AjaxResult saleData(String performancesId){
        return smileShowService.saleData(performancesId);
    }
}
