package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetWechatUsersServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "小程序-用户相关")
@RestController
@RequestMapping("/wechatUsers")
@Slf4j
public class SweetWechatUsersController {

    @Autowired
    private SweetWechatUsersServiceImpl usersService;



    @PostMapping("doTask")
    @ApiOperation("做积分任务")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "4关注任务")
    })
    public ResponseDto doTask(@RequestParam Integer type) {
        String phone = (String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_MOBILE);
        String userId = (String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_SUB);
        return usersService.doTask(type, phone, userId);
    }

}
