package com.liquidnet.common.third.xuper.util;

import com.baidu.xasset.auth.XchainAccount;
import com.baidu.xasset.client.base.BaseDef;
import com.baidu.xasset.client.xasset.Asset;
import com.baidu.xasset.client.xasset.XassetDef;
import com.baidu.xuper.api.Account;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.constant.XuperErrorEnum;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperSdkUtil
 * @Package com.liquidnet.common.third.xuper.util
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/15 15:50
 */
@Slf4j
@Component
public class XuperSdkUtil {
    @Autowired
    private XuperConfig xuperConfig;

    private Asset getAsset(){
        return xuperConfig.getAsset();
    }

    private Account createAccount(){
        return XchainAccount.newXchainEcdsaAccount(XchainAccount.mnemStrgthStrong, XchainAccount.mnemLangEN);
    }

    public Account getAccount(String mnemonic){
        return XchainAccount.retrieveAccByMnemonic(mnemonic, XchainAccount.mnemLangEN);
    }

    private Account getAccount(){
        return null;
    }

    /**
     * 001获取访问BOS临时STS凭证
     * @param reqDto
     * @return
     */
    public XuperResponseDto<XuperUploadFileRespDto> xuperUploadFile(XuperUploadFileReqDto reqDto){
        XuperUploadFileRespDto respDto = XuperUploadFileRespDto.getNew();
        try{
            Account account = this.getAccount(reqDto.getMnemonic());
            String fileName = reqDto.getFileName();
            String filePath = reqDto.getFilePath();
            byte[] dataByte = reqDto.getDataByte();
            String property = reqDto.getProperty();
            XassetDef.UploadFile uploadFile = getAsset().uploadFile(account, fileName, filePath, dataByte, property);
            BaseDef.RequestRes requestRes = uploadFile.res;
            if(requestRes.httpCode==200){
                log.debug("xuperUploadFile resp : "+ JsonUtils.toJson(uploadFile));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(uploadFile),new TypeReference<XuperUploadFileRespDto>(){});
            }
            log.debug("xuperUploadFile resp : "+ JsonUtils.toJson(respDto));
        }catch(Exception e){
            log.error("error msg "+e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }


    /**
     * 000创建数字账户
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper000CreateAccountRespDto> xuper000CreateAccount(Xuper000CreateAccountReqDto reqDto){
        Xuper000CreateAccountRespDto respDto = Xuper000CreateAccountRespDto.getNew();
        try{
            // 创建区块链账户
            Account acc = this.createAccount();
            respDto.setPubKeyStr(acc.getKeyPair().getJSONPublicKey());
            respDto.setPriKeyStr(acc.getKeyPair().getJSONPrivateKey());
            respDto.setAddress(acc.getAddress());
            respDto.setMnemonic(acc.getMnemonic());
            log.debug("xuper000CreateAccount resp : "+ JsonUtils.toJson(respDto));
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 001获取访问BOS临时STS凭证
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper001GetStokenRespDto> xuper001GetStoken(Xuper001GetStokenReqDto reqDto){
        Xuper001GetStokenRespDto respDto = Xuper001GetStokenRespDto.getNew();
        try{
            Account acc = this.getAccount(reqDto.getMnemonic());
            BaseDef.Resp<XassetDef.GetStokenResp> getStokenResp = getAsset().getStoken(acc);
            log.debug("pubKeyStr ===> {}",acc.getKeyPair().getJSONPublicKey());
            log.debug("priKeyStr ===> {}",acc.getKeyPair().getJSONPrivateKey());
            log.debug("address ===> {}",acc.getAddress());
            log.debug("address ===> {}",acc.getMnemonic());
            BaseDef.RequestRes requestRes = getStokenResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper001GetStoken resp : "+ JsonUtils.toJson(getStokenResp));
                log.debug("xuper001GetStoken apiResp : "+ JsonUtils.toJson(getStokenResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(getStokenResp.apiResp),new TypeReference<Xuper001GetStokenRespDto>(){});
            }
        }catch(Exception e){
            log.error("error msg "+e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 002创造数字资产
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper002CreateAssetRespDto> xuper002CreateAsset(Xuper002CreateAssetReqDto reqDto){
        Xuper002CreateAssetRespDto respDto = Xuper002CreateAssetRespDto.getNew();
        try{
            //创建资产区块链账户
            Account account = getAccount(reqDto.getMnemonic());
            //数字资产数量。0：无限授予碎片
            long amount = reqDto.getAmount();
            //藏品显示售卖价格，单位为分
            final long price = reqDto.getPrice();

            //数字资产信息
            int assetCate = reqDto.getAssetCate();
            String title = reqDto.getTitle();
            String[] thumb = {reqDto.getThumb()};
            String shortDesc = reqDto.getShortDesc();
            String[] imgDesc = {reqDto.getImgDesc()};
            String[] assetUrl = {reqDto.getAssetUrl()};
            String longDesc = reqDto.getLongDesc();
            String assetExt = reqDto.getAssetExt();
            long groupId = reqDto.getGroupId();
            XassetDef.AssetInfo assetInfo = new XassetDef.AssetInfo(assetCate,title,thumb,shortDesc,imgDesc,assetUrl,longDesc,assetExt,groupId);

            //业务侧用户id（可选）
            long userId = reqDto.getUserId();
            //要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
            String fileHash = reqDto.getFileHash();

            BaseDef.Resp<XassetDef.CreateAssetResp> createAssetResp = getAsset().createAsset(account, amount, assetInfo, userId, price);
            BaseDef.RequestRes requestRes = createAssetResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper002CreateAsset resp : "+ JsonUtils.toJson(createAssetResp));
                log.debug("xuper002CreateAsset apiResp : "+ JsonUtils.toJson(createAssetResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(createAssetResp.apiResp),new TypeReference<Xuper002CreateAssetRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 003修改未发行的数字资产
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper003AlterAssetRespDto> xuper003AlterAsset(Xuper003AlterAssetReqDto reqDto){
        Xuper003AlterAssetRespDto respDto = Xuper003AlterAssetRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            //创建资产区块链账户
            Account account = getAccount(reqDto.getMnemonic());
            //数字资产数量。0：无限授予碎片
            long amount = reqDto.getAmount();
            //藏品显示售卖价格，单位为分
            final long price = reqDto.getPrice();

            //数字资产信息
            int assetCate = reqDto.getAssetCate();
            String title = reqDto.getTitle();
            String[] thumb = {reqDto.getThumb()};
            String shortDesc = reqDto.getShortDesc();
            String[] imgDesc = {reqDto.getImgDesc()};
            String[] assetUrl = {reqDto.getAssetUrl()};
            String longDesc = reqDto.getLongDesc();
            String assetExt = reqDto.getAssetExt();
            long groupId = reqDto.getGroupId();
            XassetDef.AssetInfo assetInfo = new XassetDef.AssetInfo(assetCate,title,thumb,shortDesc,imgDesc,assetUrl,longDesc,assetExt,groupId);

            //业务侧用户id（可选）
            long userId = reqDto.getUserId();
            //要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
            String fileHash = reqDto.getFileHash();

            BaseDef.Resp<BaseDef.BaseResp> alterAssetResp = getAsset().alterAsset(account, assetId, amount, assetInfo, price);
            BaseDef.RequestRes requestRes = alterAssetResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper003AlterAsset resp : "+ JsonUtils.toJson(alterAssetResp));
                log.debug("xuper003AlterAsset apiResp : "+ JsonUtils.toJson(alterAssetResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(alterAssetResp.apiResp),new TypeReference<Xuper003AlterAssetRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 004链上发行数字资产
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper004PublishAssetRespDto> xuper004PublishAsset(Xuper004PublishAssetReqDto reqDto){
        Xuper004PublishAssetRespDto respDto = Xuper004PublishAssetRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            //创建资产区块链账户
            Account account = getAccount(reqDto.getMnemonic());
            //是否存证。0：不存证 1：普通存证。默认 0（可选）
            int isEvidence = 0;

            BaseDef.Resp<BaseDef.BaseResp> publishAssetResp = getAsset().publishAsset(account, assetId, isEvidence);
            log.debug("xuper004PublishAsset resp : "+ JsonUtils.toJson(publishAssetResp));
            BaseDef.RequestRes requestRes = publishAssetResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper004PublishAsset apiResp : "+ JsonUtils.toJson(publishAssetResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(publishAssetResp.apiResp),new TypeReference<Xuper004PublishAssetRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 005查询数字商品详情
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper005QueryAssetRespDto> xuper005QueryAsset(Xuper005QueryAssetReqDto reqDto){
        Xuper005QueryAssetRespDto respDto = Xuper005QueryAssetRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            BaseDef.Resp<XassetDef.QueryAssetResp> queryAssetResp = getAsset().queryAsset(assetId);
            log.debug("xuper005QueryAsset resp : "+ JsonUtils.toJson(queryAssetResp));
            BaseDef.RequestRes requestRes = queryAssetResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper005QueryAsset apiResp : "+ JsonUtils.toJson(queryAssetResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(queryAssetResp.apiResp),new TypeReference<Xuper005QueryAssetRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 006拉取账户创造资产列表
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper006ListAssetByAddrRespDto> xuper006ListAssetByAddr(Xuper006ListAssetByAddrReqDto reqDto){
        Xuper006ListAssetByAddrRespDto respDto = Xuper006ListAssetByAddrRespDto.getNew();
        try{
            //资产状态。0：全部 1：初试 3：发行中 4：发行成功。默认 0（可选）
            int status = reqDto.getStatus();
            //要拉取的区块链账户地址
            String addr = reqDto.getAddr();
            //要拉取页数，第一页为1
            int page = reqDto.getPage();
            //每页拉取数量，默认20，最大50（可选）
            int limit = reqDto.getLimit();

            BaseDef.Resp<BaseDef.ListPageResp> listPageResp = getAsset().listAssetsByAddr(status, addr, page, limit);
            log.debug("xuper006ListAssetByAddr resp : "+ JsonUtils.toJson(listPageResp));
            BaseDef.RequestRes requestRes = listPageResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper006ListAssetByAddr apiResp : "+ JsonUtils.toJson(listPageResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(listPageResp.apiResp),new TypeReference<Xuper006ListAssetByAddrRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 007授予数字商品碎片
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper007GrantShardRespDto> xuper007GrantShard(Xuper007GrantShardReqDto reqDto){
        Xuper007GrantShardRespDto respDto = Xuper007GrantShardRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            //创建资产区块链账户
            Account account = getAccount(reqDto.getMnemonic());
            //碎片id
            long shardId = reqDto.getShardId();
            //资产接收者区块链地址
            String toAddr = reqDto.getToAddr();
            //资产接收者用户id（可选）
            long toUserId = reqDto.getToUserId();
            //碎片价格（可选）
            long price = reqDto.getPrice();

            BaseDef.Resp<XassetDef.GrantShardResp> grantShardResp = getAsset().grantShard(account, assetId, shardId, toAddr, toUserId, price);
            log.debug("xuper007GrantShard resp : "+ JsonUtils.toJson(grantShardResp));
            BaseDef.RequestRes requestRes = grantShardResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper007GrantShard apiResp : "+ JsonUtils.toJson(grantShardResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(grantShardResp.apiResp),new TypeReference<Xuper007GrantShardRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 008转移资产碎片（暂不开放）
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper008TransferShardRespDto> xuper008TransferShard(Xuper008TransferShardReqDto reqDto){
        Xuper008TransferShardRespDto respDto = Xuper008TransferShardRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            //资产拥有者区块链账户
            Account account = getAccount(reqDto.getMnemonic());
            //碎片id
            long shardId = reqDto.getShardId();
            //资产接收者区块链地址
            String toAddr = reqDto.getToAddr();
            //资产接收者用户id（可选）
            long toUserId = reqDto.getToUserId();
            //碎片价格（可选）
            long price = reqDto.getPrice();

            BaseDef.Resp<BaseDef.BaseResp> transferShardResp = getAsset().transferShard(account, assetId, shardId, toAddr, toUserId, price);
            log.debug("xuper008TransferShard resp : "+ JsonUtils.toJson(transferShardResp));
            BaseDef.RequestRes requestRes = transferShardResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper008TransferShard apiResp : "+ JsonUtils.toJson(transferShardResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(transferShardResp.apiResp),new TypeReference<Xuper008TransferShardRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 009碎片核销
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper009ConsumeRespDto> xuper009Consume(Xuper009ConsumeReqDto reqDto){
        Xuper009ConsumeRespDto respDto = Xuper009ConsumeRespDto.getNew();
        try{
            //资产创建者区块链账户
            Account cAccount = null;
            //资产碎片拥有者账户
            Account uAccount = null;
            //资产id
            long assetId = 123;
            //碎片id
            long shardId = 123;
            BaseDef.Resp<BaseDef.BaseResp> consumeShardResp = getAsset().consumeShard(cAccount, uAccount, assetId, shardId);
            log.debug("xuper009Consume resp : "+ JsonUtils.toJson(consumeShardResp));
            BaseDef.RequestRes requestRes = consumeShardResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper009Consume apiResp : "+ JsonUtils.toJson(consumeShardResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(consumeShardResp.apiResp),new TypeReference<Xuper009ConsumeRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 010查询指定资产碎片信息
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper010QuerySdsRespDto> xuper010QuerySds(Xuper010QuerySdsReqDto reqDto){
        Xuper010QuerySdsRespDto respDto = Xuper010QuerySdsRespDto.getNew();
        try{
            //资产id
            long assetId = reqDto.getAssetId();
            //碎片id
            long shardId = reqDto.getShardId();
            BaseDef.Resp<XassetDef.QueryShardsResp> queryShardsResp = getAsset().queryShards(assetId, shardId);
            log.debug("xuper010QuerySds resp : "+ JsonUtils.toJson(queryShardsResp));
            BaseDef.RequestRes requestRes = queryShardsResp.res;
            if(requestRes.httpCode==200){
                log.debug("xuper010QuerySds apiResp : "+ JsonUtils.toJson(queryShardsResp.apiResp));
                respDto = JsonUtils.fromJson(JsonUtils.toJson(queryShardsResp.apiResp),new TypeReference<Xuper010QuerySdsRespDto>(){});
            }
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 011分页拉取指定账户持有碎片列表
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper011ListSdsByAddrRespDto> xuper011ListSdsByAddr(Xuper011ListSdsByAddrReqDto reqDto){
        Xuper011ListSdsByAddrRespDto respDto = Xuper011ListSdsByAddrRespDto.getNew();
        try{
            //要拉取的区块链账户地址
            String addr = "";
            //要拉取页数，第一页为1
            int page = 1;
            //每页拉取数量，默认20，最大50（可选）
            int limit = 20;
            BaseDef.Resp<BaseDef.ListPageResp> listPageResp = getAsset().listShardsAddr(addr, page, limit);
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 012分页拉取指定资产已授予碎片列表
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper012ListSdsByAstRespDto> xuper012ListSdsByAst(Xuper012ListSdsByAstReqDto reqDto){
        Xuper012ListSdsByAstRespDto respDto = Xuper012ListSdsByAstRespDto.getNew();
        try{
            //资产id
            long assetId = 123;
            //分页游标，首页设置空字符串（可选）
            String cursor = "123";
            //每页拉取数量，默认20，最多50（可选）
            int limit = 20;
            BaseDef.Resp<BaseDef.ListCursorResp> listCursorResp = getAsset().listShardsByAsset(assetId, cursor, limit);
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 013拉取数字商品历史登记记录
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper013HistoryRespDto> xuper013History(Xuper013HistoryReqDto reqDto){
        Xuper013HistoryRespDto respDto = Xuper013HistoryRespDto.getNew();
        try{
            //资产id
            long assetId = 123;
            //要拉取页数，第一页为1
            int page = 1;
            //每页拉取数量，默认20，最大50（可选）
            int limit = 20;
            BaseDef.Resp<BaseDef.ListPageResp> listPageResp = getAsset().history(assetId, page, limit);
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 014冻结发行成功资产，后续授予操作将被禁止
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper014FreezeAssetRespDto> xuper014FreezeAsset(Xuper014FreezeAssetReqDto reqDto){
        Xuper014FreezeAssetRespDto respDto = Xuper014FreezeAssetRespDto.getNew();
        try{
            //创建资产区块链账户
            Account account = null;
            //资产id
            long assetId = 123;
            BaseDef.Resp<BaseDef.BaseResp> baseResp = getAsset().freezeAsset(assetId, account);
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }

    /**
     * 015获取商品存证信息
     * @param reqDto
     * @return
     */
    public XuperResponseDto<Xuper015GetEvidenceInfoRespDto> xuper015GetEvidenceInfo(Xuper015GetEvidenceInfoReqDto reqDto){
        Xuper015GetEvidenceInfoRespDto respDto = Xuper015GetEvidenceInfoRespDto.getNew();
        try{
            //资产id
            long assetId = 123;
            BaseDef.Resp<XassetDef.GetEvidenceInfoResp> evidenceInfoResp = getAsset().getEvidenceInfo(assetId);
        }catch(Exception e){
            log.error(e.getMessage(),e);
            throw new XupterException(XuperErrorEnum.SERVER_INNER_ERROR.getCode(),XuperErrorEnum.SERVER_INNER_ERROR.getMsg());
        }
        return XuperResponseDto.success(respDto);
    }
}
