package com.liquidnet.service.kylin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.kylin.dao.OrderPushDamaiDto;
import com.liquidnet.service.kylin.dao.OrderScriptDto;
import com.liquidnet.service.kylin.dao.OrderTicketsListDao;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceOrderListAdminDao;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 订单 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 14:00 下午
 */
public interface KylinOrderTicketsMapper extends BaseMapper<KylinOrderTickets> {

    // 查询演出订单能退款的总金额和总订单数量
    HashMap<String, Object> getPerformanceRefundOrderStatis(@Param("targetId") String targetId, @Param("paymentType") String[] paymentType);

    // 获取可退款的订单信息
    List<KylinOrderTickets> getCanRefundOrderList(@Param("targetId") String targetId, @Param("mid") int mid, @Param("limitNum") int limitNum);

    List<OrderTicketsListDao> orderList(Map<String, Object> map);

    List<OrderPushDamaiDto> pushDamaiDetailsList(String ticketsId);

    List<OrderScriptDto> orderScriptDto(String userId);

    List<PerformanceExpressPerformanceOrderListAdminDao> performanceExpressPerformanceOrderList(Map<String, Object> map);

    List<KylinOrderTickets> getCanPlaceOrderList(@Param("performanceId") String performanceId, @Param("mid") int mid, @Param("limitNum") int limitNum);

    List<KylinOrderTickets> getCanCancelOrderList(@Param("performanceId") String performanceId, @Param("mid") int mid, @Param("limitNum") int limitNum);
}
