package com.liquidnet.service.adam.test;

import com.mongodb.BasicDBObject;
import com.mongodb.client.model.IndexModel;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestMongodbIndexCreate
 * @Package com.liquidnet.service.adam.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/7 17:02
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestMongodbIndexCreateExample {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Test
    public  void createMongodbIndex(){
        String[] collectionNames = {"test-mongo"};
//        String[] collectionNames = {"AdamUserInfoVo","AdamRealInfoVo","AdamThirdPartInfoVo","AdamUserMemberVo","AdamMemberVo"};

        for(String collectionName:collectionNames){
            if(mongoTemplate.collectionExists(collectionName)){
                System.out.printf("执行错误！");
                return;
            }
            //需要创建的索引集合
            List<IndexModel> indexModels = new ArrayList<>();
            BasicDBObject index1 = new BasicDBObject();
            index1.put("name",1);
            indexModels.add(new IndexModel(index1));

            BasicDBObject index2 = new BasicDBObject();
            index2.put("name",1);
            index2.put("age",1);
            indexModels.add(new IndexModel((index2)));
            mongoTemplate.createCollection(collectionName).createIndexes(indexModels);
        }
    }
}
