package com.liquidnet.service.adam.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order = 10000)
@Api(tags = "一覽無遺")
@Slf4j
@Validated
@RestController
@RequestMapping("plz")
public class AdamPlazaController {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    // TODO: 2021/7/5 Value值由PHP.media服务API存入，这里只做查取（缓解PHP服务器扩容问题），且介于PHP存取REDIS序列化问题，这里暂时使用StringRedisTemplate取值
    private static final String AD_INFO_FROM_PHP = "adam:ad:info";

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "开屏广告")
    @GetMapping(value = {"ad"})
    public ResponseDto<Object> ad() {
        return ResponseDto.success(JsonUtils.fromJson(stringRedisTemplate.opsForValue().get(AD_INFO_FROM_PHP), JsonNode.class));
    }
}
