package com.liquidnet.service.platform.controller.partner;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.service.partner.IKylinTicketsPartnerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 票 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Api(tags = "第三方-票",position = 1003)
@RestController
@RequestMapping("partner/ticket")
@Validated
public class KylinTicketsPartnerController {

    @Autowired
    private IKylinTicketsPartnerService ticketsPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建票务",position = 1 )
    @ApiResponse(response = KylinTicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketPartnerVo> createTicketSummary(@RequestBody @Valid TicketCreateParam ticketCreateParam) {
        return ticketsPartnerService.createTicketSummary(ticketCreateParam);
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改票务",position = 2)
    @ApiResponse(response = KylinTicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketPartnerVo> updateTicket(@RequestBody @Valid TicketCreateParam ticketCreateParam) {
        return ticketsPartnerService.updateTicket(ticketCreateParam);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除票务",position = 3)
    @ApiResponse( code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteTicket(@RequestParam("ticketsId") @NotNull String ticketsId) {
        return ticketsPartnerService.deleteTicket(ticketsId);
    }

    @PostMapping(value = "/copy")
    @ApiOperation(value = "复制票务",position = 4)
    @ApiResponse(response = KylinTicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketPartnerVo> copyTicket(@RequestParam("performancesId") @NotNull String performancesId,@RequestParam("ticketsId") @NotNull String ticketsId) {
        return ticketsPartnerService.copyTicket(performancesId,ticketsId);
    }

    @GetMapping(value = "/details")
    @ApiOperation(value = "获取票务详情",position = 5)
    @ApiResponse(response = KylinTicketPartnerVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinTicketPartnerVo> getTicketsMongo(@RequestParam("ticketsId") @NotNull String ticketsId) {
        KylinTicketPartnerVo result = null;
        result = ticketsPartnerService.getTicketsMongo(ticketsId);
        if (null == result) {
            return ResponseDto.failure("查询票务信息失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @PostMapping(value = "/onLine")
    @ApiOperation(value = "票上线",position = 6)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> onLine(@RequestParam("ticketsId") @NotNull String ticketsId,@RequestParam("performancesId") @NotNull String performancesId) {
        return ticketsPartnerService.onLine(ticketsId,performancesId);
    }

    @PostMapping(value = "/outLine")
    @ApiOperation(value = "票下线",position = 7)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> outLine(@RequestParam("ticketsId") @NotNull String ticketsId,@RequestParam("performancesId") @NotNull String performancesId) {
        return ticketsPartnerService.outLine(ticketsId,performancesId);
    }
}
