package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberCodeAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberPriceAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

@Api(tags = "会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("adam/member")
public class AdamMemberAdminController {
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberPriceAdminService adamMemberPriceAdminService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;
    @Autowired
    RedisUtil redisUtil;

    @RequiresPermissions("adam:member:list")
    @ApiOperation(value = "会员卡列表")
    @PostMapping("list")
    public ResponseDto<List<AdamMemberVo>> list() {
        List<AdamMember> list = adamMemberService.list(
                Wrappers.lambdaQuery(AdamMember.class).select(
                        AdamMember::getMemberId, AdamMember::getName, AdamMember::getTitle, AdamMember::getType, AdamMember::getState
                )
        );
        List<AdamMemberVo> vos = new ArrayList<>();
        list.forEach(r -> {
            vos.add(AdamMemberVo.getNew().copy(r));
        });
        return ResponseDto.success(vos);
    }

    @RequiresPermissions("adam:member:add")
    @ApiOperation(value = "添加会员卡")
    @PostMapping("add")
    public ResponseDto<Object> add(@Valid @RequestBody AdamMemberParam parameter) {
        adamMemberService.add(parameter);
        return ResponseDto.success();
    }

    @RequiresPermissions("adam:member:info")
    @ApiOperation(value = "会员卡详情")
    @PostMapping("info")
    public ResponseDto<Object> info(@NotBlank @RequestParam String memberId) {
        return ResponseDto.success(adamMemberService.getOne(
                Wrappers.lambdaQuery(AdamMember.class).eq(AdamMember::getMemberId, memberId)
        ));
    }

    @RequiresPermissions("adam:member:edit")
    @ApiOperation(value = "会员卡编辑")
    @PostMapping("edit")
    public ResponseDto<Object> edit(@Valid @RequestBody AdamMemberParam parameter) {
        adamMemberService.edit(parameter);
        return ResponseDto.success();
    }

    @RequiresPermissions("adam:member:gen_code")
    @ApiOperation(value = "生成兑换码")
    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@Valid @RequestBody AdamMemberCodeParam parameter) {
        if (1 != parameter.getType()) {
            return ResponseDto.failure("参数有误[TYPE]");
        }
        int count = adamMemberPriceAdminService.count(
                Wrappers.lambdaQuery(AdamMemberPrice.class)
                        .eq(AdamMemberPrice::getMemberPriceId, parameter.getMemberPriceId())
                        .eq(AdamMemberPrice::getMemberId, parameter.getMemberId())
                        .eq(AdamMemberPrice::getState, 1)
        );
        if (count <= 0) {
            return ResponseDto.failure("会员卡ID/价格ID无效");
        }
        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }
}
