package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 购票须知表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinBuyNotice implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * buy_notice_id
     */
    private String buyNoticeId;

    /**
     * 标题
     */
    private String title;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 内容
     */
    private String message;

    /**
     * 状态 1可用 0弃用
     */
    private Integer status;

    /**
     * 排序 大在上
     */
    private Integer sort;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
