package com.liquidnet.service.goblin.controller.Inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.GoblinNftNumAccountServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Slf4j
@Api(tags = "@API:RSC")
@RestController
@Validated
@RequestMapping("/rsc")
public class GoblinRscController {

    @Autowired
    GoblinNftNumAccountServiceImpl accountService;

    @PostMapping("nft/sync/acc")
    @ApiOperation("数字账户开通同步通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "userId", value = "用户ID", example = "1", required = true),
    })
    public ResponseDto<Boolean> syncNotice(
            @RequestParam("userId") @NotBlank(message = "用户ID不能为空") String userId
    ) {
        Boolean notice = accountService.syncNotice(userId);
        if (notice) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }

}
