package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

import java.util.ArrayList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 拉取数字商品历史登记记录
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper013HistoryRespDto {
    public long requestId;
    public int errNo;
    public String errMsg;
    public ArrayList<AssetInfo> list;
    public int totalCnt;

    @Data
    public static class AssetInfo {
        public long assetId;
        public long type;
        public long shardId;
        public long price;
        public String txId;
        public String from;
        public String to;
        public long ctime;
    }


    private static final Xuper013HistoryRespDto obj = new Xuper013HistoryRespDto();
    public static Xuper013HistoryRespDto getNew() {
        try {
            return (Xuper013HistoryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper013HistoryRespDto();
        }
    }
}
