package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 订单快递状态
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderExpressStatus implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String orderExpressStatusId;
    private String orderExpressId;

    private String orderStateCode;            // 订单状态
    private String orderStateDesc;            // 订单状态描述
    private String empCode;            // 收件员工工号
    private String empPhone;            // 收件员手机号
    private String netCode;            // 网点
    private String lastTime;            // 最晚上门时间
    private String bookTime;             // 客户预约时间
    private String carrierCode;        // 承运商代码(SF)

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;

    private static final KylinOrderExpressStatus obj = new KylinOrderExpressStatus();
    public static KylinOrderExpressStatus getNew() {
        try {
            return (KylinOrderExpressStatus) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderExpressStatus();
        }
    }
}
