package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinSqlOrderAgainRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_ORDER_AGAIN;

@Configuration
public class ConsumerKylinSqlOrderAgainRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerKylinSqlOrderAgainRdsReceiver consumerKylinSqlOrderAgainRdsReceiver;

//    /**
//     * 订单再次支付
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlOrderAgain(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SQL_ORDER_AGAIN.getGroup(), getConsumerName(SQL_ORDER_AGAIN.name() + t)),
//                StreamOffset.create(SQL_ORDER_AGAIN.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlOrderAgainRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 订单再次支付 */
//
//    @Bean
//    public Subscription subscriptionSqlOrderAgain0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlOrderAgain(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */

    @Bean// 订单再次支付
    public List<Subscription> subscriptionSqlOrderAgain(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.KylinQueue stream = MQConst.KylinQueue.SQL_ORDER_AGAIN;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlOrderAgainRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
