package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商铺营销表[活动]
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreMarketing implements Serializable ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 商铺营销表id
     */
    private String storeMarketId;

    /**
     * 营销名称
     */
    private String name;

    /**
     * 营销类型[1-满赠|2-限时秒杀]
     */
    private Integer type;

    /**
     * 活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]
     */
    private Integer status;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 营销描述
     */
    private String desc;

    /**
     * 营销开始时间
     */
    private LocalDateTime startTime;

    /**
     * 营销结束时间营销为定金预售的时候，该时间也是第二阶段付款的时间营销为全款预售的时候，该时间也是发货时间
     */
    private LocalDateTime endTime;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private Integer delFlag;

    /**
     * 活动是否预热[0-否|1-是]
     */
    private Integer isPre;

    /**
     * 活动预热时间
     */
    private LocalDateTime preTime;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinStoreMarketing obj = new GoblinStoreMarketing();
    public static GoblinStoreMarketing getNew() {
        try {
            return (GoblinStoreMarketing) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMarketing();
        }
    }
}
