package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.service.smile.entity.SmileAgent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Api(tags = "票提管理")
@RestController
@RequestMapping("/smile/agent")
public class SmileAgentController {

    @Autowired
    ISmileAgentService smileAgentService;

    private Boolean tag = true;

    @PostMapping("/list")
    @ApiOperation("根据PerId获取票提")
    @ResponseBody
    public AjaxResult getAgent(@RequestParam(name = "performancesId")String performancesId){
        return smileAgentService.getAgent(performancesId);
    }

    @PostMapping("/create")
    @ApiOperation("创建/修改 票提")
    @ResponseBody
    public AjaxResult create(@RequestBody List<SmileAgent> smileAgents){
        return smileAgentService.create(smileAgents);
    }

    @PostMapping("/delPerId")
    @ApiOperation("删除（旧版）演出id集合")
    @ResponseBody
    public AjaxResult delPerId(){
        if (tag){
            smileAgentService.delPerId();
            tag = false;
            return AjaxResult.success();
        }
        return AjaxResult.warn("已删除");
    }


}
