package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "GoblinNowOrderListParam")
@Data
public class GoblinNowOrderListParam implements Cloneable {

    @ApiModelProperty(required = false, value = "页数")
    private int page;
    @ApiModelProperty(required = true, value = "店铺id")
    private String storeId;
    @ApiModelProperty(required = true, value = "活动id")
    private String marketId;
    @ApiModelProperty(required = true, value = "订单号")
    private String orderCode;


    private static final GoblinNowOrderListParam obj = new GoblinNowOrderListParam();

    public static GoblinNowOrderListParam getNew() {
        try {
            return (GoblinNowOrderListParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNowOrderListParam();
        }
    }
}
