package com.liquidnet.service.bank.common;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.service.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel()
@Data
public class BankResultDto<T> implements Serializable {

    @ApiModelProperty(value = "错误码,0代表成功", position = -9998)
    private String code = ErrorCode.SUCCESS.getCode();

    @ApiModelProperty(value = "错误描述", position = -9997)
    private String message;

    @ApiModelProperty
    private T data;

    public boolean isSuccess() {
        return this.code.equals(BankErrorCode.SUCCESS.getCode());
    }

    private BankResultDto(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private BankResultDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    private BankResultDto(BankErrorCode error) {
        if (error != null) {
            this.code = error.getCode();
            this.message = error.getVal();
        }

    }

    private BankResultDto(BankErrorCode error, T data) {
        this.code = error.getCode();
        this.message = error.getVal();
        this.data = data;
    }

    public static <Object> BankResultDto<Object> success(Object data) {
        return new BankResultDto<>(BankErrorCode.SUCCESS, data);
    }

    public static <Object> BankResultDto<Object> success() {
        return new BankResultDto<>(BankErrorCode.SUCCESS);
    }

    public static <Object> BankResultDto<Object> failure(BankErrorCode error) {
        return new BankResultDto<>(error);
    }

    public static <Object> BankResultDto<Object> failure(BankErrorCode error, Object data) {
        return new BankResultDto<>(error, data);
    }

    public static <Object> BankResultDto<Object> failure(String code, String message) {
        return new BankResultDto<>(code, message);
    }

    public static <Object> BankResultDto<Object> failure(String code, String message, Object data) {
        return new BankResultDto<>(code, message, data);
    }

    public static ResponseDto getResponseDto(BankResultDto dto) {
        return new ResponseDto<>(dto.getCode(), dto.getMessage(), dto.getData());
    }

}
