package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamAddressesParam", description = "添加/编辑收获地址入参")
@Data
public class AdamAddressesParam implements java.io.Serializable {
    private static final long serialVersionUID = -2626425843975309892L;
    @ApiModelProperty(position = 10, required = false, value = "收获地址ID，编辑时必传[64]")
    private String addressesId;
    @ApiModelProperty(position = 11, required = true, value = "入场人名称[50]", example = "Swagger")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "手机号[11]", example = "13111111111")
    private String phone;
    @ApiModelProperty(position = 13, required = true, value = "省份[30]", example = "北京")
    private String province;
    @ApiModelProperty(position = 14, required = true, value = "城市[30]", example = "北京城区")
    private String city;
    @ApiModelProperty(position = 15, required = true, value = "区县[30]", example = "朝阳区")
    private String county;
    @ApiModelProperty(position = 16, required = true, value = "详细地址[100]", example = "广渠路1号创1958园区")
    private String address;
}
