package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinSkusSearchDto", description = "Sku搜素")
@Data
public class GoblinSkusSearchDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094904L;
    @ApiModelProperty(position = 11, value = "店铺id")
    private String spuId;
    @ApiModelProperty(position = 11, value = "店铺名称")
    private String spuName;

    private static final GoblinSkusSearchDto obj = new GoblinSkusSearchDto();

    public static GoblinSkusSearchDto getNew() {
        try {
            return (GoblinSkusSearchDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSkusSearchDto();
        }
    }
}
