package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 27.积分销毁
 * @class: PointDestroyReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:41
 */
@Data
public class Nft027PointDestroyReqDto implements Serializable {
    /**
     * 销毁人的地址
     */
    private String addr;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 积分数量
     */
    private String count;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的ID
     */
    private String operateId;
    /**
     * 销毁人的私钥签名，签名对象是(platformPubKey_addr_接口名_count_operateId)  接口名=destroy_point
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;

    private static final Nft027PointDestroyReqDto obj = new Nft027PointDestroyReqDto();
    private static final long serialVersionUID = -5434465832252861420L;

    public static Nft027PointDestroyReqDto getNew() {
        try {
            return (Nft027PointDestroyReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft027PointDestroyReqDto();
        }
    }
}
