package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 会员价格
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberPrice implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 会员价格ID
     */
    private String memberPriceId;

    /**
     * 会员类型ID
     */
    private String memberId;

    /**
     * 状态  0 不可用 1上线中 2已下线
     */
    private Integer status;

    /**
     * 会员包名称
     */
    private String name;

    /**
     * 原价
     */
    private BigDecimal price;

    /**
     * 折扣价
     */
    private BigDecimal priceFixed;

    /**
     * 会员包有效天数
     */
    private Integer days;

    /**
     * 会员包须知
     */
    private String detail;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;
}
