package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreMgtGoodsSkuListVo", description = "商品管理:商品款式信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtGoodsSkuListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5926827517337445529L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[45]")
    private String skuId;
    @ApiModelProperty(position = 14, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 20, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 22, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 23, value = "总库存")
    private Integer totalStock;
    @ApiModelProperty(position = 24, value = "剩余库存")
    private Integer surplusStock;
    @ApiModelProperty(position = 27, value = "开售时间")
    private String saleStartTime;
    @ApiModelProperty(position = 27, value = "停售时间")
    private String saleStopTime;
}
