 package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品单品
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSku implements Serializable {

    private static final long serialVersionUID = 1L;

    private String skuId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 单品编码
     */
    private String skuNo;

    /**
     * 单品条码
     */
    private String skuBarCode;

    /**
     * ERP规格编码
     */
    private String skuErpCode;

    /**
     * 商品类型[0-常规|1-数字藏品]
     */
    private Integer skuType;

    /**
     * 单品的名称
     */
    private String name;

    /**
     * 单品的副标题
     */
    private String subtitle;

    /**
     * 单品销售价-原价
     */
    private BigDecimal sellPrice;

    /**
     * 单品默认图片的url
     */
    private String skuPic;

    /**
     * 展示文件URL
     */
    private String skuWatch;

    /**
     * 展示文件类型[1-图片|2-视频|3-模型]
     */
    private String watchType;

    /**
     * 展示预览图片
     */
    private String skuWatchPic;

    /**
     * ISBN，针对CD/图书等
     */
    private String skuIsbn;

    /**
     * 总库存
     */
    private Integer stock;

    /**
     * 单品库存
     */
    private Integer skuStock;

    /**
     * 预警库存
     */
    private Integer warningStock;

    /**
     * 单品现价
     */
    private BigDecimal price;

    /**
     * IOS商品价格
     */
    private BigDecimal priceV;

    /**
     * IOS商品价格ID
     */
    private String productId;

    /**
     * 单品会员价格
     */
    private BigDecimal priceMember;

    /**
     * 单品的重量
     */
    private BigDecimal weight;

    /**
     * 简介
     */
    private String intro;

    /**
     * 详情
     */
    private String details;

    /**
     * 购买限制[0-全部用户|1-仅会员|2-指定用户]
     */
    private String buyFactor;

    /**
     * 购买限制人员名单[购买限制为2-指定用户时必填]
     */
    private String buyRoster;

    /**
     * 限量[0-无限制|X:限购数量]
     */
    private Integer buyLimit;

    /**
     * 商品的店铺id，如果是平台的则为0
     */
    private String storeId;

    /**
     * 上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]
     */
    private String shelvesHandle;

    /**
     * 预约上架时间[上架处理方式为3-预约定时上架时需要指定]
     */
    private LocalDateTime shelvesTime;

    /**
     * 开售时间
     */
    private LocalDateTime saleStartTime;

    /**
     * 停售时间
     */
    private LocalDateTime saleStopTime;

    /**
     * 单品有效期
     */
    private LocalDateTime skuValidity;

    /**
     * 是否是虚拟商品[0-否|1-是]
     */
    private String virtualFlg;

    /**
     * 审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]
     */
    private String status;

    /**
     * 审核拒绝原因
     */
    private String reason;

    /**
     * 单品上架状态[0-待上架|1-下架|2-违规|3-上架]
     */
    private String shelvesStatus;

    /**
     * 是否售罄[0-否|1-是]
     */
    private String soldoutStatus;

    /**
     * 是否隐藏[0-默认展示|1-隐藏]
     */
    private String skuAppear;

    /**
     * 是否购买[0-否|1-是]
     */
    private String skuCanbuy;

    /**
     * 是否盲盒[0-否|1-是]
     */
    private String unbox;

    /**
     * 盲盒命中率[0.01~100%]
     */
    private BigDecimal hitRatio;

    /**
     * 盲盒开启时间
     */
    private LocalDateTime openingTime;

    /**
     * 盲盒开启时限[单位秒]
     */
    private Integer openingLimit;

    /**
     * 删除标记[0-未删除|1删除]
     */
    private String delFlg;

    /**
     * 上架时间
     */
    private LocalDateTime shelvesAt;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    /**
     * 物流模版id
     */
    private String logisticsTemplate;

    private String comment;


}
