package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.HelpValueVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author TT
 */
@Data
public class GoblinGoodsAnticipateShareVo  implements Serializable,Cloneable{

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private String sid;

    /**
     * 用户uid
     */
    private String uid;

    /**
     * 用户昵称
     */
    private String nickname;

    /**
     * sku_Id
     */
    private String skuId;

    @ApiModelProperty("预约类型（1：预约提醒，2：预约获得购买资格）")
    private Integer type;

    @ApiModelProperty("设置预约人数")
    private Integer peopleType;

    /**
     * 用户头像
     */
    private String avatar;

    /**
     * 助力人数
     */
    @ApiModelProperty(value = "目前有多少助力")
    private Integer helpPeople;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    /**
     * 创建时
     */
    private LocalDateTime createdDate;

    /**
     * 头像集合
     */
    private List<String> avatarImgList;


    private static final GoblinGoodsAnticipateShareVo obj = new GoblinGoodsAnticipateShareVo();

    public static GoblinGoodsAnticipateShareVo getNew() {
        try {
            return (GoblinGoodsAnticipateShareVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsAnticipateShareVo();
        }
    }


}
