package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author TT
 */
@Data
public class SmileUserStateParam {

    @ApiModelProperty(value = "手机号", example = "")
    private String phone;

    @ApiModelProperty(value = "代理类型（1：总代，2：普代）", example = "")
    private Integer type;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "页数", example = "")
    @NotNull(message = "页数不能为空")
    private Integer pageNum;

}
