package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户手机号地域信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamUserMobileLocate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String uid;

    /**
     * 当前手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件号
     */
    private String idCard;

    /**
     * 0-INIT,1-NORMAL,2-INVALID
     */
    private Integer state;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 运营商
     */
    private String corp;

    /**
     * 区号
     */
    private String areaCode;

    /**
     * 邮编
     */
    private String postCode;

    /**
     * 注册手机号
     */
    private String registMobile;

    /**
     * 注册IP
     */
    private String registAddr;

    /**
     * 注册来源
     */
    private String registSource;

    private LocalDateTime registAt;

    /**
     * 最近登录IP
     */
    private String latestAddr;

    /**
     * 最近登录来源
     */
    private String latestSource;

    private LocalDateTime latestAt;

    private LocalDateTime updatedAt;

    private String comment;


}
