package com.liquidnet.service.candy.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponMemberDto;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 券发放管理 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
public interface CandyMgtCouponMapper extends BaseMapper<CandyMgtCoupon> {

    /**
     * <p>
     * 查取券发放列表
     * </p>
     *
     * @param listParam CandyMgtCouponListParam
     * @return List<CandyMgtCouponInfoDto>
     */
    List<CandyMgtCouponInfoDto> selectMultiForMgtCouponInfoDto(CandyMgtCouponListParam listParam);

    /**
     * <p>
     * 查取会员礼包券信息
     * </p>
     *
     * @param mrightsIdList List<String>
     * @return List<CandyMgtCouponMemberDto>
     */
    List<CandyMgtCouponMemberDto> selectMultiForMgtCouponMemberDto(@Param("mrightsIdList") List<String> mrightsIdList);
}
