package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetManualDto implements Serializable ,Cloneable{

    @ApiModelProperty("电子手册id")
    private String manualId;
    @ApiModelProperty("演出id")
    private String performancesId;
    @ApiModelProperty("演出名称")
    private String title;
    @ApiModelProperty("演出开始时间")
    private String timeStart;
    @ApiModelProperty("演出结束时间")
    private String timeEnd;
    @ApiModelProperty("售卖时间")
    private String timeSell;
    @ApiModelProperty("停售时间")
    private String timeStop;
    @ApiModelProperty("状态")
    private Integer status;
    @ApiModelProperty("手册状态")
    private Integer manualStatus;
    @ApiModelProperty("是否发布")
    private Integer isRelease;

    private static final SweetManualDto obj = new SweetManualDto();
    public static SweetManualDto getNew() {
        try {
            return (SweetManualDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualDto();
        }
    }
}
