package com.liquidnet.service.zxlnft;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.nio.charset.StandardCharsets;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 13:49
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlWalletSdkUtil {
    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    /**
     * 1、生成助记词
     */
    @Test
    public void createMnemonic(){
        CreateMnemonicReq req = CreateMnemonicReq.getNew();
        zxlWalletSdkUtil.createMnemonic(req);
    }

    /**
     * 2、API签名
     */
    @Test
    public void generateApiSign(){
        GenerateApiSignReq req = GenerateApiSignReq.getNew();
        req.setAppId("");
        req.setAppKey("");
        zxlWalletSdkUtil.generateApiSign(req);
    }

    /**
     * 3、文件上传至COS
     */
    @Test
    public void uploadToCos(){
        UploadToCosReq req = UploadToCosReq.getNew();
//        req.setCosPath("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/"+"zxl_image_test_001");
//        req.setTempSecretId("AKIDhVGgR7gKaVE5qUIpSPD9k6pcmUj7fobmEspHDlCjC27Te6Dmputh-fI87qvL2EDT");
//        req.setTempSecretKey("xuNqn+FfVjm0Ug0je9k1Mn5MQHKlWKs18uU03KIMAH0=");
//        req.setSessionToken("fwJfhxx5ILXFYNItgiQid1bBiTrofX5af128eb2fa96eef4d9841c98756853142d0X-nPNtZgA0AEIwJ-MAJigzB3IZOgDjLorykjfoxAHusyQ_HeAhvHSlORtPol_iqqJVolGP78H5byiZKhKxATIZiJzrTCQysR02tR1vJPkJp03VH70sSzTJ3WcyTPpBs_NCuXkYvLZaDbRKmE8Xln4uqDJDSthNNaQKBJBYJNnxmVpCRCIeIyqOvQrSKXRGkvkjQ79Enlq7iUeKSqXrpKEBliAq9hgMrXPRHapqihseRl-WerjB4BgQ261mmOuZD6oHg37EPy_JrHAJxHh9dJlFlqz3CxUL-We36RcQeDpLvL1KuzZUBBmjSb0SYMvnun7SOEDdDMF0-1ApATsyQ-bTgDiCHAoo5Xqf9CcFKop-rUeQEDKSV17raeRRcN6ZcBQ-BJ5s4R4bqRm3y1nUwePNKD1Hi2__-nPUKuI5o535wkQcqMeDhQ40Fg3jCcPPRJ-9_Egp3yTEraTkfihKDAXTZnhiQdxaDInlP1JFJKZwY5b0hinlW6yaxnaUzYyXqTVY2tEufNOu5Sn4fGOTZmyqJJ0oDsCJiby-92vKqIS9fHIzemEXfuCULNdonmEThspBA7tUAUr-fY1KCjTMolhG0XvsJ-hNVzwNbpLMLd87TwajlyqJisnn5-sR-wuj9Hx9Inoe5kTRX-0F0NeP9vcfpYZns5No5jrBM74HMgOOSplXZ3yuML42LxTtw9SWcsxqFQJpohTyijpbrwdkKlwc0qGyUIPy7WQ7Jltb7iE");
//        req.setFilePath("/Users/anjiabin/Downloads/zxl_image_test_001.jpg");
//        req.setFilePath("/Users/anjiabin/Downloads/zxl_image_test_002.jpeg");
        req.setFilePath("/Users/anjiabin/Downloads/zxl_image_series_test_001.jpeg");
//        zxlWalletSdkUtil.uploadToCos(req,null);
        zxlWalletSdkUtil.uploadToCos(req,"NOW_ZXL_NFT_PIC001");
    }

    /**
     * 4、文件上传至COS(form-data文件提交)
     */
    @Test
    public void uploadFileToCos(){
        UploadFileToCosReq req = UploadFileToCosReq.getNew();
//        req.setCosPath("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/zxl_image_test_001");
//        req.setTempSecretId("AKIDhVGgR7gKaVE5qUIpSPD9k6pcmUj7fobmEspHDlCjC27Te6Dmputh-fI87qvL2EDT");
//        req.setTempSecretKey("xuNqn+FfVjm0Ug0je9k1Mn5MQHKlWKs18uU03KIMAH0=");
//        req.setSessionToken("fwJfhxx5ILXFYNItgiQid1bBiTrofX5af128eb2fa96eef4d9841c98756853142d0X-nPNtZgA0AEIwJ-MAJigzB3IZOgDjLorykjfoxAHusyQ_HeAhvHSlORtPol_iqqJVolGP78H5byiZKhKxATIZiJzrTCQysR02tR1vJPkJp03VH70sSzTJ3WcyTPpBs_NCuXkYvLZaDbRKmE8Xln4uqDJDSthNNaQKBJBYJNnxmVpCRCIeIyqOvQrSKXRGkvkjQ79Enlq7iUeKSqXrpKEBliAq9hgMrXPRHapqihseRl-WerjB4BgQ261mmOuZD6oHg37EPy_JrHAJxHh9dJlFlqz3CxUL-We36RcQeDpLvL1KuzZUBBmjSb0SYMvnun7SOEDdDMF0-1ApATsyQ-bTgDiCHAoo5Xqf9CcFKop-rUeQEDKSV17raeRRcN6ZcBQ-BJ5s4R4bqRm3y1nUwePNKD1Hi2__-nPUKuI5o535wkQcqMeDhQ40Fg3jCcPPRJ-9_Egp3yTEraTkfihKDAXTZnhiQdxaDInlP1JFJKZwY5b0hinlW6yaxnaUzYyXqTVY2tEufNOu5Sn4fGOTZmyqJJ0oDsCJiby-92vKqIS9fHIzemEXfuCULNdonmEThspBA7tUAUr-fY1KCjTMolhG0XvsJ-hNVzwNbpLMLd87TwajlyqJisnn5-sR-wuj9Hx9Inoe5kTRX-0F0NeP9vcfpYZns5No5jrBM74HMgOOSplXZ3yuML42LxTtw9SWcsxqFQJpohTyijpbrwdkKlwc0qGyUIPy7WQ7Jltb7iE");
//        req.setName("/Users/anjiabin/Downloads/zxl_image_test_001.jpg");
//        req.setFile("/Users/anjiabin/Downloads/zxl_image_test_001.jpg");
        zxlWalletSdkUtil.uploadFileToCos(req);
    }

    /**
     * 5、派生生成子公私钥对
     */
    @Test
    public void deriveKeyPair(){
        DeriveKeyPairReq req = DeriveKeyPairReq.getNew();
//        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setMnemonic("stuff");
        req.setIndex(0l);
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.deriveKeyPair(req);
    }

    /**
     * 6、SDK签名
     */
    @Test
    public void signByPriKey(){
        SignByPriKeyReq req = SignByPriKeyReq.getNew();
//        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.signByPriKey(req);
    }

    /**
     * 10、SDK验签
     */
    @Test
    public void verifyByPubKey(){
        VerifyByPubKeyReq req = VerifyByPubKeyReq.getNew();
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        req.setSignedData("3045022100f062e29953951317c6577ba5d7641d3f19c38930dbb8a93e7b9be699f3f208450220723b87ec6c1f4efd3f70b39b586b74bf52576c6ca8a8bb3d9ddd21255651dff8");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlWalletSdkUtil.verifyByPubKey(req);
    }

    /**
     * 11、SDK-SM3哈希 这个是44位，暂时不用
     */
    @Test
    public void sM3Hash(){
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
//        SM3HashReq req = SM3HashReq.getNew();
//        req.setData(cosUrl.getBytes(StandardCharsets.UTF_8));
//        zxlWalletSdkUtil.sM3Hash(req);
    }

    /**
     * 12、SDK-SM3哈希EnCode 这个是64位
     */
    @Test
    public void sM3HashEncode(){
        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241628485194860245.jpg";
//        String cosUrl = "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef//2022-02-24/ZXLNFTIMAGE202202241704292368452405.jpg";
        SM3HashEncodeReq req = SM3HashEncodeReq.getNew();
        req.setData(cosUrl.getBytes(StandardCharsets.UTF_8));
        zxlWalletSdkUtil.sM3HashEncode(req);
    }
}
