package com.liquidnet.service.zxlnft;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.Nft034PublishReqDto;
import com.liquidnet.common.third.zxlnft.dto.Nft034PublishRespDto;
import com.liquidnet.common.third.zxlnft.dto.ZxlnftResponseDto;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 13:49
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlnftSdkUtil {
    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Test
    public void nft016IdentityBindQuery(){
        Nft016IdentityBindQueryReq req = Nft016IdentityBindQueryReq.getNew();

        Nft016IdentityBindQueryResp resp = zxlnftSdkUtil.nft016IdentityBindQuery(req);
    }

    @Test
    public void nft021UploadUrl(){
        Nft021UploadUrlReq req = Nft021UploadUrlReq.getNew();
//        req.setSeriesName("");
        req.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
//        req.setUserIdentification(zxlnftConfig.getPlatformIdentification());
        Nft021UploadUrlResp resp = zxlnftSdkUtil.nft021UploadUrl(req);
    }

    @Test
    public void nft022UploadSecret(){
        Nft022UploadSecretReq req = Nft022UploadSecretReq.getNew();
//        req.setSeriesName("");
        req.setTimestamp(DateUtil.getNowSeconds().toString());
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String pubData = req.getTimestamp() + "_" + req.getUserPubKey();
        String userData = req.getTimestamp();
        //系列不为空
//        String pubData = req.getTimestamp() + "_" + req.getSeriesName() + "_" + req.getUserPubKey();
//        String userData = req.getTimestamp() + "_" + req.getSeriesName();

        req.setPubSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),pubData));
        req.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));

        Nft022UploadSecretResp resp = zxlnftSdkUtil.nft022UploadSecret(req);
    }

    @Test
    public void nft034Publish(){
        Nft034PublishReqDto reqDto = Nft034PublishReqDto.getNew();
        reqDto.setAuthor("正在现场作者");
        reqDto.setName("正在现场NFT001");
        reqDto.setUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDisplayUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDesc("NFT描述信息");
        reqDto.setFlag("文创");
        reqDto.setPublishCount(10l);
//      reqDto.setSeriesId("");
        reqDto.setSeriesBeginIndex(1);
        reqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        reqDto.setSellCount(1000l);
        reqDto.setOperateId(IDGenerator.get32UUID());
        reqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> resp = zxlnftSdkUtil.nft034Publish(reqDto);
        System.out.println(resp.toJson());
    }
}
