DROP TABLE IF EXISTS `goblin_mix`;
CREATE TABLE `goblin_mix`
(
    `mid`           bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `mix_id`        varchar(64)                        DEFAULT '' COMMENT '混合id',
    `uid`           varchar(64)                        DEFAULT '' COMMENT '用户id',
    `name`          varchar(64)                        DEFAULT '' COMMENT '混合名称',
    `time_start`    datetime                           DEFAULT null COMMENT '开始时间',
    `time_end`      datetime                           DEFAULT null COMMENT '结束时间',
    `status`        int                                DEFAULT 0 COMMENT '状态[6-启用|7-停用]',
    `show_position` int                                DEFAULT 0 COMMENT '展示位置[1-商城|2-数字藏品]',
    `sell_name`     varchar(64)                        DEFAULT '' COMMENT '售卖名称',
    `cate_fid`      varchar(30)                        DEFAULT NULL COMMENT '平台一级分类id',
    `cate_sid`      varchar(30)                        DEFAULT NULL COMMENT '平台二级分类id',
    `cate_tid`      varchar(30)                        DEFAULT NULL COMMENT '平台三级分类id',
    `intro`         varchar(512)                       DEFAULT NULL COMMENT '商品简介/购买须知',
    `cover_pic`     varchar(256)                       DEFAULT NULL COMMENT '封面图片地址',
    `video`         varchar(256)                       DEFAULT NULL COMMENT '商品视频地址/数字昌平视频地址',
    `details`       text COMMENT '商品详情/藏品详情',
    `watch_type`    char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '展示文件类型[1-图片|2-视频|3-模型]',
    `detail_url`    varchar(256)                       DEFAULT NULL COMMENT '数字藏品图片地址',

    `stock`         int                                DEFAULT 0 COMMENT '库存',
    `stock_lock`    int                                DEFAULT 0 COMMENT '锁定库存',
    'is_lock'       int                                DEFAULT 0 COMMENT '是否锁定库存[0-否|1-是]',
    'limit'         int                                DEFAULT 0 COMMENT '限购数量[0-不限购]',
    `white_type`    int                                DEFAULT 1 COMMENT '白名单类型[0-会员|1-指定用户|2-全部用户]',
    `white_url`     varchar(512)                       DEFAULT '' COMMENT '白名单xls地址',

    `del_tag`       int                                DEFAULT 0 COMMENT '是否删除[0-否|1-是]',
    `comment`       varchar(255)                       DEFAULT '' COMMENT '补充字段',
    `created_at`    datetime        NULL               DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`    datetime        NULL               DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-搭售活动'
  ROW_FORMAT = DYNAMIC;
--   goblin_goods_tag-标签表  goblin_goods_image-图片表 goblin_goods_service_support-商品联服务

DROP TABLE IF EXISTS `goblin_mix_details`;
CREATE TABLE `goblin_mix_details`
(
    `mid`        bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `mix_id`     varchar(64)          DEFAULT '' COMMENT '混合id',
    `position`   int                  DEFAULT 0 COMMENT '商品类型[1-商城|2-数字藏品]',
    `sell_id`    varchar(64)          DEFAULT '' COMMENT '售卖商品id',
    `price`      DECIMAL(64)          DEFAULT '' COMMENT '单品现价',
    `price_v`    decimal(20, 2)       DEFAULT 0.00 COMMENT '苹果商品价格',
    `count`      int                  DEFAULT 0 COMMENT '数量[数字藏品默认为1]',
    `can_refund` int                  DEFAULT 0 COMMENT '是否支持退款[0-否|1-是]',
    `del_tag`    int                  DEFAULT 0 COMMENT '是否删除[0-否|1-是]',
    `comment`    varchar(255)         DEFAULT '' COMMENT '补充字段',
    `created_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-搭售活动详情'
  ROW_FORMAT = DYNAMIC;

-- 商品/nft 订单表增加字段 mix_id
ALTER TABLE goblin_nft_order
    ADD mix_id VARCHAR(64) NOT NULL DEFAULT '' COMMENT '组合售id';
ALTER TABLE goblin_store_order
    ADD mix_id VARCHAR(64) NOT NULL DEFAULT '' COMMENT '组合售id';
