package com.liquidnet.client.admin.web.controller.zhengzai.tools;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.*;
import com.liquidnet.client.admin.zhengzai.kylin.service.IExportService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

@Controller
@RequestMapping("tools/export")
public class ExportDataController extends BaseController {

    @Autowired
    private IExportService exportService;


    private String prefix = "zhengzai/financial";

    @GetMapping()
    public String financial() {
        return prefix + "/export";
    }

    /**
     * 导出订单明细
     *
     * @param exportType
     * @param beginTime
     * @param endTime
     * @param showId
     * @return
     */
    @PostMapping("/export/orderInfo")
    @ResponseBody
    public AjaxResult exportOrderInfo(Integer exportType, String beginTime, String endTime, String showId) {
        if (null == exportType) {
            return error("导出类型有误！");
        }
        if (exportType == 1) {//按订单时间导出信息
            if (!timeIsNotNull(beginTime, endTime)) {
                return error("按时间类型导出，开始时间和结束时间不能为空！");
            }
            List<OrderDetailedExportVo> list = exportService.exportOrderByOrderTime(beginTime, endTime);
            if (list.size() > 0) {
                ExcelUtil<OrderDetailedExportVo> util = new ExcelUtil(OrderDetailedExportVo.class);
                return util.exportExcel(list, exportType + "");
            }
        } else if (exportType == 2) {//按演出时间导出信息
            if (!timeIsNotNull(beginTime, endTime)) {
                return error("按时间类型导出，开始时间和结束时间不能为空！");
            }
            List<OrderDetailedByShowDateExportVo> byShowTimeList = exportService.exportOrderByShowTime(beginTime, endTime);
            if (byShowTimeList.size() > 0) {
                ExcelUtil<OrderDetailedByShowDateExportVo> util = new ExcelUtil(OrderDetailedByShowDateExportVo.class);
                return util.exportExcel(byShowTimeList, exportType + "");
            }
        } else if (exportType == 3) {//按id导出信息
            if (!StringUtils.isNotBlank(showId)) {
                return error("演出id不能为空！");
            }
            List<OrderDetailedByShowIdExportVo> byShowIdList = exportService.exportOrderByShowId(showId);
            if (byShowIdList.size() > 0) {
                ExcelUtil<OrderDetailedByShowIdExportVo> util = new ExcelUtil(OrderDetailedByShowIdExportVo.class);
                return util.exportExcel(byShowIdList, exportType + "");
            }
        }
        return error("查无信息！");
    }

    private boolean timeIsNotNull(String beginTime, String endTime) {
        return StringUtils.isNotBlank(beginTime) && StringUtils.isNotBlank(endTime) ? true : false;
    }


    /**
     * 导出会员订单
     *
     * @param beginTime
     * @param endTime
     * @return
     */
    @PostMapping("/export/memberOrder")
    @ResponseBody
    public AjaxResult exportMemberOrder(String beginTime, String endTime) {
        if (!timeIsNotNull(beginTime, endTime)) {
            return error("开始时间和结束时间不能为空！");
        }
        List<OrderMemberExportVo> list = exportService.exportMemberOrder(beginTime, endTime);
        if (list.size() == 0) {
            return error("查无信息");
        }
        ExcelUtil<OrderMemberExportVo> util = new ExcelUtil(OrderMemberExportVo.class);
        return util.exportExcel(list, "会员订单");
    }

    /**
     * 导出商品订单
     *
     * @param beginTime
     * @param endTime
     * @return
     */
    @PostMapping("/export/commodityOrder")
    @ResponseBody
    public AjaxResult exportCommodityOrder(String beginTime, String endTime) {
        if (!timeIsNotNull(beginTime, endTime)) {
            return error("开始时间和结束时间不能为空！");
        }
        List<OrderCommodityExportVo> list = exportService.exportCommodityOrder(beginTime, endTime);
        if (list.size() == 0) {
            return error("查无信息");
        }
        ExcelUtil<OrderCommodityExportVo> util = new ExcelUtil(OrderCommodityExportVo.class);
        return util.exportExcel(list, "商品订单");
    }

}
