package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberCode {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;
    /**
     * 会员码
     */
    private String code;
    /**
     * 类型:1-购买,2-赠送(后台生成)
     */
    private Integer type;
    /**
     * 会员类型id
     */
    private String memberId;
    /**
     * 会员价格id
     */
    private String memberPriceId;
    /**
     * 会员卡号
     */
    private String memberNo;
    /**
     * 状态 0-未使用 1-已使用 2-已过期
     */
    private Integer state;
    /**
     * 购买会员码订单号
     */
    private String buyOrderNo;
    /**
     * 购买会员码的用户id
     */
    private String buyUid;
    /**
     * 购买时间
     */
    private LocalDateTime buyAt;
    /**
     * 使用会员码的订单号
     */
    private String useOrderNo;
    /**
     * 使用会员码的用户ID
     */
    private String useUid;
    /**
     * 使用时间
     */
    private LocalDateTime useAt;

    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;

}
