package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetDouDouCheckParam;
import com.liquidnet.service.sweet.param.SweetDouDouParam;
import com.liquidnet.service.sweet.service.ISweetDoudouService;
import com.liquidnet.service.sweet.vo.SweetDouDouVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * doudou预约签名CD记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-06-04
 */
@Api(tags = "活动-doudou")
@RestController
@RequestMapping("/doudou")
public class SweetDoudouController {
    @Autowired
    private ISweetDoudouService iSweetDoudouService;

    @GetMapping("")
    @ApiOperation("获取用户预约详情")
    public ResponseDto<SweetDouDouVo> info() {
        return iSweetDoudouService.info();
    }

    @PostMapping("")
    @ApiOperation("预约")
    public ResponseDto create(@Valid @RequestBody SweetDouDouParam param) {
        return iSweetDoudouService.create(param);
    }

    @PostMapping("/detail")
    @ApiOperation("核验-码详情")
    public ResponseDto<SweetDouDouVo> detail(@Valid @RequestBody SweetDouDouCheckParam param){
        return iSweetDoudouService.detail(param);
    }

    @PostMapping("/check")
    @ApiOperation("核销")
    public ResponseDto check(@Valid @RequestBody SweetDouDouCheckParam param){
        return iSweetDoudouService.check(param);
    }
}
