package com.liquidnet.service.galaxy.router.zxin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTrade;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterTradeHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinTradeBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterTradeHandler(GalaxyEnum.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlTradeImpl implements IGalaxyRouterStrategyTrade {
    @Autowired
    private ZxinTradeBiz zxinTradeBiz;

    @Override
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return zxinTradeBiz.nftPublishAndBuy(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto) {
        return zxinTradeBiz.nftBuyResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(GalaxyNftBuyPayResultQueryReqDto reqDto) {
        return zxinTradeBiz.nftBuyPayResultQuery(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        return zxinTradeBiz.nftBuy(reqDto);
    }
}
