package com.liquidnet.service.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxySeriesInfoVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

@Slf4j
@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    private long keyExpireTime = 3600*24*30;

    public void setGalaxyUserInfo(String routeType,String userId, GalaxyUserInfoBo userInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId,userInfoBo,keyExpireTime);
        mongoTemplate.save(userInfoBo,GalaxyUserInfoBo.class.getSimpleName());
    }

    public GalaxyUserInfoBo getGalaxyUserInfo(String routeType,String userId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId);
        if(obj!=null){
            return (GalaxyUserInfoBo) obj;
        }else {
            GalaxyUserInfoBo userInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("userId").is(userId)), GalaxyUserInfoBo.class, GalaxyUserInfoBo.class.getSimpleName());
            if (userInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId, userInfoBo);
            return userInfoBo;
        }
    }

    public void setSeriesInfoBo(String routeType,String skuId, GalaxySeriesInfoBo seriesInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId,seriesInfoBo,keyExpireTime);
        mongoTemplate.save(seriesInfoBo,GalaxySeriesInfoBo.class.getSimpleName());
    }

    public GalaxySeriesInfoBo getSeriesInfoBo(String routeType, String skuId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesInfoBo) obj;
        }else {
            GalaxySeriesInfoBo seriesInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("skuId").is(skuId)), GalaxySeriesInfoBo.class, GalaxySeriesInfoBo.class.getSimpleName());
            if (seriesInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId, seriesInfoBo);
            return seriesInfoBo;
        }
    }

    public void updateSeriesClaimStatus(String routeType,String skuId, GalaxySeriesInfoBo seriesInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId,seriesInfoBo,keyExpireTime);

        Query query = Query.query(Criteria.where("skuId").is(seriesInfoBo.getSkuId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(seriesInfoBo)));
        update.set("seriesClaimStatus", seriesInfoBo.getSeriesClaimStatus());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxySeriesInfoVo.class,GalaxySeriesInfoVo.class.getSimpleName());
        log.info("updateSeriesClaimStatus result:{}",result.toString());
    }

    public void setNftOrderBo(String routeType,String nftOrderPayId, GalaxyNftOrderBo nftOrderBo) {

        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);
        /**
         * 入库mongo
         */
        GalaxyNftOrderVo nftOrderVo = GalaxyNftOrderVo.getNew();
        BeanUtil.copy(nftOrderBo,nftOrderVo);
        mongoTemplate.save(nftOrderVo,GalaxyNftOrderVo.class.getSimpleName());
    }

    public GalaxyNftOrderBo getNftOrderBo(String routeType, String nftOrderPayId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId);
        if(obj!=null){
            return (GalaxyNftOrderBo) obj;
        }else {
            GalaxyNftOrderVo nftOrderVo = mongoTemplate.findOne(Query.query(Criteria.where("nftOrderPayId").is(nftOrderPayId)), GalaxyNftOrderVo.class, GalaxyNftOrderVo.class.getSimpleName());
            if (nftOrderVo == null) {
                return null;
            }
            GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
            BeanUtil.copy(nftOrderVo,nftOrderBo);
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId, nftOrderBo);
            return nftOrderBo;
        }
    }

    public void updateNftOrderInfo(String routeType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);

        Query query = Query.query(Criteria.where("nftOrderPayId").is(nftOrderBo.getNftOrderPayId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(nftOrderBo)));
        update.set("nftId", nftOrderBo.getNftId());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxyNftOrderBo.class,GalaxyNftOrderBo.class.getSimpleName());
        log.info("updateNftOrderInfo result:{}",result.toString());
    }

}
