package com.liquidnet.service.feign.sweet.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(name = "liquidnet-service-sweet",
        contextId = "FeignSweetTaskClient", path = "",
        url = "${liquidnet.service.sweet.url}",
//        url = "",
        fallback = FallbackFactory.Default.class)
public interface FeignSweetTaskClient {

    @PostMapping("sweet/sweetData/drawLuck/add")
    ResponseDto<Boolean> drawLuckAdd();

}
