package com.liquidnet.service.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IdentityUtils;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理(需要登陆状态)")
@RestController
@RequestMapping("/front")
@Slf4j
public class SmileUserController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileFrontService smileFrontService;
    @Autowired
    private MongoTemplate mongoTemplate;

    @GetMapping("getUser")
    @ApiOperation("获取用户状态，如果没查到，则返回null")
    public ResponseDto<SmileUserVO> getUser() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVO= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        return ResponseDto.success(smileUserVO);
    }
    @GetMapping("getSchool")
    @ApiOperation("获得学校")
    public ResponseDto<List<SmileSchoolVo>> getSchool() {
        String userId = CurrentUtil.getCurrentUid();
        List<SmileSchoolVo> list=null;
        if(redisUtil.hasKey(SmileRedisConst.SMILE_SCHOOL)){
            list= (List<SmileSchoolVo>) redisUtil.get(SmileRedisConst.SMILE_SCHOOL);
        }
        return ResponseDto.success(list);
    }
    @GetMapping("getPerformance")
    @ApiOperation("获得演出列表")
    public ResponseDto<List<KylinPerformanceVo>> getPerformance() {
        return ResponseDto.success(smileFrontService.getPerformance());
    }
    @GetMapping("repeatAuth")
    @ApiOperation("重新认证")
    public ResponseDto repeatAuth() {
        String userId = CurrentUtil.getCurrentUid();
        //判断是否认证了。
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
     /*   if(null!=smileUserVORedis&&null!= smileUserVORedis.getType()&&(smileUserVORedis.getType()==2||smileUserVORedis.getType()==1)){
            return ResponseDto.failure("该用户已认证!");
        }*/
        redisUtil.del(SmileRedisConst.SMILE_USER.concat(userId));
        smileFrontService.deleteUser(userId);
        return ResponseDto.success();
    }
    @GetMapping("auth")
    @ApiOperation("认证")
    public ResponseDto auth() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        if(null!=smileUserVORedis){
            if(smileUserVORedis.getAuthStatus()==1){
                return ResponseDto.success(true);
            }else{
                smileUserVORedis.setAuthStatus(1);
                redisUtil.set(SmileRedisConst.SMILE_USER.concat(userId),smileUserVORedis);
                return ResponseDto.success(smileFrontService.auth(userId,smileUserVORedis));
            }
        }
        return ResponseDto.failure("没有该用户信息");
    }


    //
    @PostMapping("saveOrUpdateUserOneStep")
    @ApiOperation("增加或者删除第一步")
    public ResponseDto saveOrUpdateUserOneStep(@Validated(SmileUserVO.saveOne.class) @RequestBody  SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        smileUserVO.setUid(userId);
        if(null==smileUserVORedis){
            smileUserVO.setTag("1");
        }else{
            smileUserVO.setTag(smileUserVORedis.getTag().concat(",1"));
        }
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"1");
        return  ResponseDto.success();
    }

    @PostMapping("saveOrUpdateUserTwoStep")
    @ApiOperation("增加或者删除第二步")
    public ResponseDto saveOrUpdateUserTwoStep(@Validated(SmileUserVO.saveTwo.class)@RequestBody SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        if(StringUtil.isNotBlank(smileUserVO.getIdCard())&&StringUtil.isNotBlank(smileUserVO.getName())){
            String userId = CurrentUtil.getCurrentUid();
            if(validate(smileUserVO.getName(),smileUserVO.getIdCard(),userId)){
                smileUserVO.setUid(userId);
                SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
                if(null==smileUserVORedis){
                    smileUserVORedis.setTag("2");
                }else{
                    if(smileUserVORedis.getTag().contains("2")){
                        ResponseDto.success(null);
                    }else{
                        smileUserVO.setTag(smileUserVORedis.getTag().concat(",2"));
                    }
                }
                smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"2");
            }else {
                return  ResponseDto.failure("验证身份证失败！");
            }
        }

        return  ResponseDto.success();
    }
    public boolean validate(String realName,String cardNo,String userid){
        Object o=redisUtil.get(SmileRedisConst.SMILE_USER_VALIDATE.concat(userid));
        //查看是否之前这个 身份证和 名字(1：验证失败 2：验证成功)
        String status= (String) redisUtil.get(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName+cardNo));
        if(null!=status&&"1".equals(status)){
            return false;
        }
        String respStr = IdentityUtils.aliThird(realName, cardNo), respErrorCode = null;
        JsonNode respJNode = JsonUtils.fromJson(respStr, JsonNode.class);
        if (null == respJNode || !"0".equals(respErrorCode = String.valueOf(respJNode.get("error_code")))) {
            log.info("###实名认证失败[{}]", respJNode);
            ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
            redisUtil.set(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName+cardNo),"1");
            return false;
        }
        redisUtil.set(SmileRedisConst.SMILE_USER_VALIDATE.concat(realName+cardNo),"2");
        return true;
    }
    @PostMapping("saveOrUpdateUserThreeStep")
    @ApiOperation("增加或者删除第三步")
    public ResponseDto saveOrUpdateUserThreeStep(@Validated(SmileUserVO.saveThree.class) @RequestBody SmileUserVO smileUserVO, MethodArgumentNotValidException exception) {
        BindingResult result = exception.getBindingResult();
        if (result!=null&&result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            if (errors != null) {
                return  ResponseDto.failure(errors.get(0).getDefaultMessage());
            }
        }
        String userId = CurrentUtil.getCurrentUid();
        smileUserVO.setUid(userId);
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        if(null==smileUserVORedis){
            smileUserVORedis.setTag("3");
        }else{
            if(smileUserVORedis.getTag().contains("3")){
            }else{
                smileUserVO.setTag(smileUserVORedis.getTag().concat(",3"));
            }
        }
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"3");
        return  ResponseDto.success();
    }

    @GetMapping("getSellDataOne")
    @ApiOperation("获取销售数据")
    public ResponseDto<SellDataVO> getSellDataOne(@RequestParam String performanceId) {
        String userId = CurrentUtil.getCurrentUid();
        SellDataVO sellDataVO = (SellDataVO) redisUtil.get(SmileRedisConst.SELL_DATA.concat(userId).concat(performanceId));
        return  ResponseDto.success(sellDataVO);
    }
    @GetMapping("getSellDataTwo")
    @ApiOperation("获取XX票订单数据")
    public ResponseDto<SellDataDetailVO> getSellDataDetail(@RequestParam String ticketId,String activeName,String ticketName) {
        String userId = CurrentUtil.getCurrentUid();
        log.debug("用户id{}",userId);
        SellDataDetailVO sellDataDetailVO1=smileFrontService.getSellDataDetail(userId,ticketId,activeName,ticketName);
        return  ResponseDto.success(sellDataDetailVO1);
    }
    @GetMapping("getCommission")
    @ApiOperation("获取佣金明细")
    public ResponseDto<CommissionVO> getCommission() {
        String userId = CurrentUtil.getCurrentUid();
        log.debug("用户id{}",userId);
        CommissionVO commissionVO= (CommissionVO) redisUtil.get(SmileRedisConst.SELL_DATA_COMMISSION.concat(userId));
        return  ResponseDto.success(commissionVO);
    }



}
