package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class CheckData implements Serializable, Cloneable {
    @ApiModelProperty(value = "0未检票，1已检票")
    private int check_status;
    @ApiModelProperty(value = "0-正常|1-黑名单")
    private String check_time;
    @ApiModelProperty(value = "票提")
    private String enter_idcode;
    @ApiModelProperty(value = "抽成票提")
    private String enter_mobile;
    @ApiModelProperty(value = "代理id")
    private String enter_name;
    @ApiModelProperty(value = "总代id")
    private String ticket_entity_id;
    @ApiModelProperty(value = "总代id")
    private String ticket_id;
    @ApiModelProperty(value = "总代id")
    private String ticket_name;
    @ApiModelProperty(value = "总代id")
    private String ticket_price;
    @ApiModelProperty(value = "1单日票 2通票")
    private Integer ticket_type;
    @ApiModelProperty(value = "总代id")
    private String ticket_use_end;
    @ApiModelProperty(value = "总代id")
    private String ticket_use_start;
    @ApiModelProperty(value = "总代id")
    private Integer ticket_count;
    @ApiModelProperty(value = "总代id")
    private Boolean select_status;

    private static final CheckData obj = new CheckData();

    public static CheckData getNew() {
        try {
            return (CheckData) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CheckData();
        }
    }
}
