package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinMgtCategorySpecVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo;
import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtExtraService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.util.List;

@ApiSupport(order = 149003)
@Api(tags = "附加数据")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/extra")
public class GoblinStoreMgtExtraController {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    IGoblinStoreMgtExtraService goblinStoreMgtExtraService;


    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "平台商品分类")
    @GetMapping("sg_categorys")
    public ResponseDto<List<GoblinSelfGoodsCategoryVo>> selfGoodsCategoryList() {
//        ArrayList<GoblinSelfGoodsCategoryVo> selfGoodsCategoryVos = ObjectUtil.getGoblinSelfGoodsCategoryVoArrayList();
//        selfGoodsCategoryVos.add(
//                GoblinSelfGoodsCategoryVo.getNew().setCateId("10000").setName("1级").setSort(1).setGrade("1").setNeIsbn("0").setCatePid(null)
//        );
//        selfGoodsCategoryVos.add(
//                GoblinSelfGoodsCategoryVo.getNew().setCateId("10100").setName("2级").setSort(1).setGrade("2").setNeIsbn("0").setCatePid("10000")
//        );
//        selfGoodsCategoryVos.add(
//                GoblinSelfGoodsCategoryVo.getNew().setCateId("10101").setName("3级").setSort(1).setGrade("3").setNeIsbn("1").setCatePid("10100")
//        );
        // TODO: 2022/1/11 redis+mongo.get
        List<GoblinSelfGoodsCategoryVo> selfGoodsCategoryVos = goblinStoreMgtExtraService.listCategoryVo();
        return ResponseDto.success(selfGoodsCategoryVos);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "平台分类规格")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "cateId", value = "分类ID"),
    })
    @GetMapping("sg_catespecs")
    public ResponseDto<List<GoblinMgtCategorySpecVo>> categorySpecList(@RequestParam String cateId) {
        if (StringUtils.isBlank(cateId)) return ResponseDto.success();
        return ResponseDto.success(goblinMongoUtils.getCategorySpecVos(cateId));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "服务支持列表")
    @PostMapping("list")
    public ResponseDto<List<GoblinServiceSupportVo>> list() {
        return ResponseDto.success(goblinStoreMgtExtraService.listServiceSupportVo());
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "标签数据", notes = "获取商品标签与音乐人、艺人、IP")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "keyword", value = "标签关键字"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "belong", value = "标签所属[0-普通标签|1-专属标签]", allowableValues = "0,1"),
    })
    @GetMapping("tags")
    public ResponseDto<List<GoblinSelfTagVo>> tagList(@RequestParam String keyword,
                                                      @NotBlank(message = "标签所属参数无效")
                                                      @Pattern(regexp = "\\b(0|1)\\b", message = "标签所属[0-普通标签|1-专属标签]")
                                                      @RequestParam String belong) {
        return ResponseDto.success(goblinStoreMgtExtraService.listTagVo(keyword, belong));
    }
}
