package com.liquidnet.service.sweet.param;

import com.liquidnet.service.sweet.dto.vo.TempBannerVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "SweetCityVoteParam", description = "用户投票记录入参")
@Data
public class TempBannerParam implements Serializable {

    @ApiModelProperty(position = 13, required = true, value = "临时banner数据")
    @NotBlank(message = "tempBannerVo不能为空")
    private List<TempBannerVo> tempBannerVo;

    @ApiModelProperty(position = 14, required = true, value = "活动类型 1新裤子 2莫宰羊", example = "1")
    @NotNull(message = "type不能为空")
    private Integer type;

}
