package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 演出状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinPerformanceRelations implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * performance_relations_id
     */
    private String performanceRelationsId;

    /**
     * 演出关联id
     */
    private String performanceId;

    /**
     * 复制来源演出id
     */
    private String copyId;

    /**
     * 商户id
     */
    private String merchantId;

    /**
     * 场地id
     */
    private String fieldId;

    /**
     * 巡演id
     */
    private String roadShowId;

    /**
     * 专题id
     */
    private String projectId;

    /**
     * 视频id
     */
    private String videoId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinPerformanceRelations obj = new KylinPerformanceRelations();
    public static KylinPerformanceRelations getNew() {
        try {
            return (KylinPerformanceRelations) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinPerformanceRelations();
        }
    }
}
