package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分活动抽奖记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivityDraw implements Serializable, Cloneable {

    private static final long serialVersionUID = 7799235431503369544L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 抽奖id
     */
    private String drawId;

    /**
     * 关联活动id
     */
    private String integralActivityId;

    /**
     * 关联奖品id
     */
    private String prizeId;

    /**
     * 关联用户id
     */
    private String userId;

    /**
     * 收货地址
     */
    private String receivingAddress;

    /**
     * 收货状态 1中奖未发放 2已发放
     */
    private Integer receivingStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivityDraw obj = new SweetIntegralActivityDraw();
    public static SweetIntegralActivityDraw getNew() {
        try {
            return (SweetIntegralActivityDraw) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityDraw();
        }
    }


}
