package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCertificationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(value = "GoblinStoreMgtCertificationParam", description = "店铺认证:认证资料入参")
@Data
public class GoblinStoreMgtCertificationParam implements java.io.Serializable {
    private static final long serialVersionUID = 6674618707269625280L;
//    @ApiModelProperty(position = 10, required = false, value = "店铺ID[编辑时必传]")
//    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "认证类型[1-企业/公司|2-个体工商户]", allowableValues = "1,2", example = "2")
    @NotBlank(message = "认证类型不能为空")
    @Pattern(regexp = "\\b(1|2)\\b", message = "认证类型无效")
    private String certType;
    @ApiModelProperty(position = 12, required = true, value = "证件类型[1-二代居民身份证]", allowableValues = "1", example = "1")
    @Pattern(regexp = "\\b(1)\\b", message = "证件类型无效")
    private String personCertType;
    @ApiModelProperty(position = 13, required = true, value = "证件姓名[32]", example = "张三")
    @Size(max = 32, message = "证件姓名长度超限")
    private String personName;
    @ApiModelProperty(position = 14, required = true, value = "证件号码[32]", example = "111111111111111111")
    @Size(max = 32, message = "证件号码位数超限")
    private String personCertCode;
    @ApiModelProperty(position = 15, required = true, value = "证件有效期[yyyy-MM-dd]", example = "2022-12-31")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "证件有效期格式有误")
    private String personCertValidity;
    @ApiModelProperty(position = 16, required = true, value = "证件是否长期有效[0-否|1-是]", example = "0")
    @NotBlank(message = "证件是否长期有效不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "证件是否长期有效参数无效")
    private String personCertLasting;
    @ApiModelProperty(position = 17, required = true, value = "证件正面照[256]", example = "http://pic.zhengzai.tv/202201/F1/50/1641481155557_6581EB9242485010CE0133147DF5D080.jpg")
    @Size(max = 256, message = "证件正面照URL过长")
    private String personCertFpic;
    @ApiModelProperty(position = 18, required = true, value = "证件背面照[256]", example = "http://pic.zhengzai.tv/202201/C3/C7/1641361041_5D81A954265418219490CB2538239880.jpg")
    @Size(max = 256, message = "证件背面照URL过长")
    private String personCertBpic;
    @ApiModelProperty(position = 19, required = true, value = "证件手持照[256]", example = "http://pic.zhengzai.tv/202201/81/30/1641362407_A60B2870D92EAD9B985289382A3ECA3A.jpg")
    @Size(max = 256, message = "证件手持照URL过长")
    private String personCertSpic;

    @ApiModelProperty(position = 19, required = false, value = "省ID[20]", example = "110000")
    @Size(max = 20, message = "省ID过长")
    private String provinceId;
    @ApiModelProperty(position = 20, required = false, value = "省名称[32]", example = "北京市")
    @Size(max = 30, message = "省名称过长")
    private String provinceName;
    @ApiModelProperty(position = 21, required = false, value = "市ID[20]", example = "110100")
    @Size(max = 20, message = "市ID过长")
    private String cityId;
    @ApiModelProperty(position = 22, required = false, value = "市名称[32]", example = "北京")
    @Size(max = 30, message = "市名称过长")
    private String cityName;
    @ApiModelProperty(position = 23, required = false, value = "县ID[20]", example = "110105")
    @Size(max = 20, message = "县ID过长")
    private String countyId;
    @ApiModelProperty(position = 24, required = false, value = "县名称[32]", example = "朝阳区")
    @Size(max = 30, message = "县名称过长")
    private String countyName;
    @ApiModelProperty(position = 25, required = false, value = "详细地址[128]", example = "XXXXX")
    @Size(max = 128, message = "详细地址过长")
    private String busAddress;

    @ApiModelProperty(position = 26, required = false, value = "商户名称[64]", example = "北京XXX服装贸易有限公司")
    @Size(max = 64, message = "商户名称长度超限")
    private String busName;
    @ApiModelProperty(position = 27, required = false, value = "统一社会信用代码[32]", example = "90000000000000005")
    @Size(max = 32, message = "统一社会信用代码位数超限")
    private String busCertCode;
    @ApiModelProperty(position = 28, required = false, value = "营业执照有效期[yyyy-MM-dd]", example = "2022-12-31")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "营业执照有效期格式有误")
    private String busCertValidity;
    @ApiModelProperty(position = 29, required = false, value = "营业执照是否长期有效[0-否|1-是]", example = "0")
    @NotBlank(message = "证件是否长期有效不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "证件是否长期有效参数无效")
    private String busCertLasting;
    @ApiModelProperty(position = 30, required = false, value = "营业执照照片[256]", example = "http://pic.zhengzai.tv/202201/3C/00/1641369685_B1673980AE72DBF44E32BE88FCA3EBA2.jpg")
    @Size(max = 256, message = "营业执照照片URL过长")
    private String busCertPic;
    @ApiModelProperty(position = 31, required = false, value = "资质证书照片[256]")
    @Size(max = 256, message = "资质证书照片URL过长")
    private String busQualityPic;

    public GoblinStoreCertificationVo initStoreCertificationVo() {
        GoblinStoreCertificationVo vo = GoblinStoreCertificationVo.getNew();
        vo.setPersonCertType(this.getPersonCertType());
        vo.setPersonName(this.getPersonName());
        vo.setPersonCertCode(this.getPersonCertCode());
        vo.setPersonCertValidity(this.getPersonCertValidity());
        vo.setPersonCertLasting(this.getPersonCertLasting());
        vo.setPersonCertFpic(this.getPersonCertFpic());
        vo.setPersonCertBpic(this.getPersonCertBpic());
        vo.setPersonCertSpic(this.getPersonCertSpic());
        vo.setDelFlg("0");
        vo.setProvinceId(this.getProvinceId());
        vo.setProvinceName(this.getProvinceName());
        vo.setCityId(this.getCityId());
        vo.setCityName(this.getCityName());
        vo.setCountyId(this.getCountyId());
        vo.setCountyName(this.getCountyName());
        vo.setBusAddress(this.getBusAddress());
        vo.setBusName(this.getBusName());
        vo.setBusCertCode(this.getBusCertCode());
        vo.setBusCertValidity(this.getBusCertValidity());
        vo.setBusCertLasting(this.getBusCertLasting());
        vo.setBusCertPic(this.getBusCertPic());
        vo.setBusQualityPic(this.getBusQualityPic());
        return vo;
    }
}
