package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.commons.lang.util.SensitizeUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamRealInfoVo", description = "实名信息")
@Data
public class AdamRealInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -3469256375584132928L;
    @ApiModelProperty(position = 10, value = "用户ID[30]")
    private String uid;
    @ApiModelProperty(position = 11, value = "姓名[30]")
    private String name;
    @ApiModelProperty(position = 12, value = "证件号[50]")
    private String idCard;
    @ApiModelProperty(position = 13, value = "类型[1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证]")
    private String type;
    @ApiModelProperty(position = 14, value = "状态:1-正常")
    private Integer state;

    private static final AdamRealInfoVo obj = new AdamRealInfoVo();

    public static AdamRealInfoVo getNew() {
        try {
            return (AdamRealInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamRealInfoVo();
    }
}
