package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券关联适用人信息
 * </p>
 *
 * @author liquidnet
 * @since 2024-01-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyUserCouponAssoc implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * ~candy_user_coupon.ucoupon_id
     */
    private String ucouponId;

    /**
     * 关联人证件类型：1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证
     */
    private Integer idType;

    /**
     * 关联人姓名
     */
    private String idName;

    /**
     * 关联人证件号码
     */
    private String idNo;

    private String comment;


}
