package com.liquidnet.service.slime.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场地申请表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SlimeFieldApplies implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * field_apply_id
     */
    private String fieldApplyId;

    /**
     * 申请状态 0待审核 1通过 2驳回
     */
    private Integer applyStatus;

    /**
     * 类型 claim认领、create创建
     */
    private String applyType;

    /**
     * 驳回原因
     */
    private String reject;

    /**
     * 申请者账号
     */
    private String uid;

    /**
     * 要认领的或创建的场地ID
     */
    private String fieldId;

    /**
     * 名称
     */
    private String name;

    /**
     * logo图片地址
     */
    private String logo;

    /**
     * 背景图片地址
     */
    private String background;

    /**
     * 介绍
     */
    private String description;

    /**
     * 建立日期
     */
    private LocalDate builtDate;

    /**
     * 省份ID
     */
    private String provinceId;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市ID
     */
    private String cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 区县ID
     */
    private String districtId;

    /**
     * 区县名称
     */
    private String districtName;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系人邮箱
     */
    private String contactEmail;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 营业执照编号
     */
    private String licenseCode;

    /**
     * 营业执照图片地址
     */
    private String licenseImg;

    /**
     * 法人姓名
     */
    private String legalName;

    /**
     * 法人身份证号码
     */
    private String legalIdentity;

    /**
     * 法人身份证正面照
     */
    private String legalIdentityObverse;

    /**
     * 法人身份证反面照
     */
    private String legalIdentityReverse;

    /**
     * 审核人ID
     */
    private String auditUid;

    /**
     * 审核人姓名
     */
    private String auditName;

    private LocalDateTime auditedAt;

    private LocalDateTime deletedAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
