package com.liquidnet.service.candy.controller;


import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.candy.util.CouponBaseUtil;
import com.liquidnet.service.candy.util.ObjectUtil;
import com.liquidnet.service.candy.util.RedisDataUtils;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyMyCouponListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 券基础信息 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Api("券相关接口")
@RestController
@RequestMapping("/candy-coupon")
public class CandyCouponController {

    @Autowired
    private RedisDataUtils redisDataUtils;

    //我的券列表
    @GetMapping("my")
    @ApiOperation("我的券列表")
    public ResponseDto<CandyMyCouponListVo> myCoupon() {
        String uid = CurrentUtil.getCurrentUid();
        List<CandyUserCouponBasicDto> dtoList = redisDataUtils.getCouponByUid(uid);
        CandyMyCouponListVo vo = CandyMyCouponListVo.getNew();
        List<CandyCouponVo> memberCoupon = ObjectUtil.getCandyCouponVoArrayList();
        List<CandyCouponVo> myCoupon = ObjectUtil.getCandyCouponVoArrayList();

        for (CandyUserCouponBasicDto dtoItem : dtoList) {
            CandyCouponVo baseVo = CouponBaseUtil.getBaseCouponUserVo(dtoItem);
            if (dtoItem.getBusiType().equals(4)) { //会员券
                memberCoupon.add(baseVo);
            } else {//非会员券
                myCoupon.add(baseVo);
            }
        }
        //排序
        memberCoupon.sort(Comparator.comparing(CandyCouponVo::getState));
        myCoupon.sort(Comparator.comparing(CandyCouponVo::getState));
        vo.setMemberCoupon(memberCoupon);
        vo.setMyCoupon(myCoupon);
        return ResponseDto.success(vo);
    }

    //要使用券列表 - 演出
    @GetMapping("preUse/performance")
    @ApiOperation("要使用券列表 - 演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "timeId", value = "场次id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "ticketId", value = "票id", required = true),
    })
    public ResponseDto<CandyMyCouponListVo> preUseCoupon(@RequestParam("priceTotal") BigDecimal priceTotal,
                                                         @RequestParam("performanceId") String performanceId,
                                                         @RequestParam("timeId") String timeId,
                                                         @RequestParam("ticketId") String ticketId) {
        String uid = CurrentUtil.getCurrentUid();
        List<CandyUserCouponBasicDto> dtoList = redisDataUtils.getCouponByUid(uid);
        CandyMyCouponListVo vo = CandyMyCouponListVo.getNew();
        List<CandyCouponVo> memberCoupon = ObjectUtil.getCandyCouponVoArrayList();
        List<CandyCouponVo> myCoupon = ObjectUtil.getCandyCouponVoArrayList();

        for (CandyUserCouponBasicDto dtoItem : dtoList) {
            CandyCouponVo baseVo = CouponBaseUtil.getPerformanceCouponUserVo(dtoItem, priceTotal,performanceId, timeId, ticketId);
            if (dtoItem.getBusiType().equals(4)) { //会员券
                memberCoupon.add(baseVo);
            } else {//非会员券
                myCoupon.add(baseVo);
            }
        }

        //排序
        memberCoupon.sort(Comparator.comparing(CandyCouponVo::getState));
        myCoupon.sort(Comparator.comparing(CandyCouponVo::getState));
        vo.setMemberCoupon(memberCoupon);
        vo.setMyCoupon(myCoupon);
        return ResponseDto.success(vo);
    }

    //要使用券列表 - 演出

    //要使用券列表 - 演出提前

    //判断券是否可用
    @GetMapping("state")
    @ApiOperation("券是否可用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券唯一表示id", required = true),
    })
    public ResponseDto<HashMap<String, Integer>> stateCoupon(@RequestParam("uCouponId") String uCouponId) {
        String uid = CurrentUtil.getCurrentUid();
        CandyUserCouponBasicDto dto = CouponBaseUtil.getSingleDtoByUCouponId(redisDataUtils.getCouponByUid(uid), uCouponId);
        if (dto == null) {
            return ResponseDto.failure();//券不存在
        }
        Integer state = CouponBaseUtil.getCouponState(LocalDateTime.now(), dto.getExpireAt(), dto.getState());
        HashMap<String, Integer> map = CollectionUtil.mapStringInteger();
        map.put("state", state);
        return ResponseDto.success(map);
    }

    //判断券是否可用并使用
    @GetMapping("use")
    @ApiOperation("券使用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券唯一表示id", required = true),
    })
    public ResponseDto<Boolean> useCoupon(@RequestParam("uCouponId") String uCouponId) {
        String uid = CurrentUtil.getCurrentUid();
        List<CandyUserCouponBasicDto> dtoList = CouponBaseUtil.useCoupon(redisDataUtils.getCouponByUid(uid), uCouponId);
        if (dtoList == null) {
            return ResponseDto.failure();
        } else {
            redisDataUtils.setCouponByUid(uid, dtoList);
        }
        return ResponseDto.success();
    }

    //回退券
    @GetMapping("useBack")
    @ApiOperation("回退券")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券唯一表示id", required = true),
    })
    public ResponseDto<Boolean> useBackCoupon(@RequestParam("uCouponId") String uCouponId) {
        String uid = CurrentUtil.getCurrentUid();
        List<CandyUserCouponBasicDto> dtoList = CouponBaseUtil.backCoupon(redisDataUtils.getCouponByUid(uid), uCouponId);
        if (dtoList == null) {
            return ResponseDto.failure();
        } else {
            redisDataUtils.setCouponByUid(uid, dtoList);
        }
        return ResponseDto.success();
    }

    //兑换券

}
