package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRefunds implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * refunds_id
     */
    private String refundsId;

    /**
     * 商户id
     */
    private String merchantId;

    /**
     * 退款状态: 0请求退款 2取消退款 1审核通过 5驳回退款 7等待退款 3正在退款 4完成退款 6退款失败
     */
    private Integer status;

    /**
     * 退款差异: 0申请退款返还库存 1自动退款无法取消退款不返还库存
     */
    private Integer type;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 订单类型 order_product 商品订单 , order_ticket 票务订单
     */
    private String orderType;

    /**
     * 订单中心订单号，这里方便查询
     */
    private String orderCode;

    /**
     * 退款内容，演出title，商品title，这里方便查询
     */
    private String orderTitle;

    /**
     * 退款手机号，这里方便查询
     */
    private String orderMobile;

    /**
     * 支付中心支付单号，用于申请退款
     */
    private String payCode;

    /**
     * 退款编号
     */
    private String orderRefundCode;

    /**
     * 退款总金额
     */
    private BigDecimal price;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 退款备注
     */
    private String remark;

    /**
     * 驳回原因
     */
    private String reject;

    /**
     * 回绝原因
     */
    private String refuse;

    /**
     * 退款中心退款编号
     */
    private String refundCode;

    /**
     * 退款类型
     */
    private String refundType;

    /**
     * 成功退款时间
     */
    private LocalDateTime refundAt;

    /**
     * 第三方退款编号
     */
    private String refundId;

    /**
     * 退款失败原因
     */
    private String refundError;

    /**
     * 申请人id
     */
    private Integer applicantId;

    /**
     * 申请人名称
     */
    private String applicantName;

    /**
     * 申请时间
     */
    private LocalDateTime applicantAt;

    /**
     * 审核人id
     */
    private Integer auditorId;

    /**
     * 审核人名称
     */
    private String auditorName;

    /**
     * 审核时间
     */
    private LocalDateTime auditorAt;

    /**
     * 执行人id
     */
    private Integer executorId;

    /**
     * 执行人名称
     */
    private String executorName;

    /**
     * 执行时间
     */
    private LocalDateTime executorAt;

    /**
     * 批量退款id
     */
    private Integer batchId;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    /**
     * 支付类型
     */
    private String paymentType;


}
