package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallResult;
import com.liquidnet.service.account.funding.vo.FundingAccountInfo;
import io.swagger.annotations.ApiModel;

import java.util.List;

/**
 * FundingQueryResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/22
 */
@ApiModel(value = "FundingQueryBalanceResult", description = "Result of account balance query")
public class FundingQueryBalanceResult extends FundingCallResult<FundingQueryBalanceParam> {
    private static final long serialVersionUID = -1815445822958121493L;
    private List<FundingAccountInfo> fundingAccountInfoList;

    public FundingQueryBalanceResult() {
    }

    public FundingQueryBalanceResult(List<FundingAccountInfo> fundingAccountInfoList) {
        this.fundingAccountInfoList = fundingAccountInfoList;
    }

    public FundingQueryBalanceResult(String code, String message) {
        super(code, message);
    }

    public List<FundingAccountInfo> getFundingAccountInfoList() {
        return fundingAccountInfoList;
    }
}
